Imports System
Imports System.Timers
Imports System.Threading
Imports System.Collections

Imports nsAlienRFID2


Public Class VBNotifications
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents groupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents label1 As System.Windows.Forms.Label
    Friend WithEvents numericUpDown1 As System.Windows.Forms.NumericUpDown
    Friend WithEvents cboPorts As System.Windows.Forms.ComboBox
    Friend WithEvents label3 As System.Windows.Forms.Label
    Friend WithEvents txtCommand As System.Windows.Forms.TextBox
    Friend WithEvents label6 As System.Windows.Forms.Label
    Friend WithEvents label5 As System.Windows.Forms.Label
    Friend WithEvents groupBox9 As System.Windows.Forms.GroupBox
    Friend WithEvents lblNotifyTime As System.Windows.Forms.Label
    Friend WithEvents txtNotifications As System.Windows.Forms.TextBox
    Friend WithEvents groupBox7 As System.Windows.Forms.GroupBox
    Friend WithEvents dgTags As System.Windows.Forms.DataGrid
    Friend WithEvents groupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents lblStatus As System.Windows.Forms.Label
    Friend WithEvents txtResponse As System.Windows.Forms.TextBox
    Friend WithEvents chkNotifyMode As System.Windows.Forms.CheckBox
    Friend WithEvents chkAutoMode As System.Windows.Forms.CheckBox
    Friend WithEvents cboNotifyTrigger As System.Windows.Forms.ComboBox
    Friend WithEvents label7 As System.Windows.Forms.Label
    Friend WithEvents udNotifyTime As System.Windows.Forms.NumericUpDown
    Friend WithEvents label4 As System.Windows.Forms.Label
    Friend WithEvents udPersistTime As System.Windows.Forms.NumericUpDown
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents cboNotifyFormat As System.Windows.Forms.ComboBox
    Friend WithEvents label8 As System.Windows.Forms.Label
    Friend WithEvents btnClear As System.Windows.Forms.Button
    Friend WithEvents ToolTip1 As System.Windows.Forms.ToolTip
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.groupBox1 = New System.Windows.Forms.GroupBox
        Me.numericUpDown1 = New System.Windows.Forms.NumericUpDown
        Me.cboPorts = New System.Windows.Forms.ComboBox
        Me.label3 = New System.Windows.Forms.Label
        Me.label1 = New System.Windows.Forms.Label
        Me.txtResponse = New System.Windows.Forms.TextBox
        Me.txtCommand = New System.Windows.Forms.TextBox
        Me.label6 = New System.Windows.Forms.Label
        Me.label5 = New System.Windows.Forms.Label
        Me.groupBox9 = New System.Windows.Forms.GroupBox
        Me.lblNotifyTime = New System.Windows.Forms.Label
        Me.txtNotifications = New System.Windows.Forms.TextBox
        Me.groupBox7 = New System.Windows.Forms.GroupBox
        Me.dgTags = New System.Windows.Forms.DataGrid
        Me.groupBox2 = New System.Windows.Forms.GroupBox
        Me.lblStatus = New System.Windows.Forms.Label
        Me.chkNotifyMode = New System.Windows.Forms.CheckBox
        Me.chkAutoMode = New System.Windows.Forms.CheckBox
        Me.cboNotifyTrigger = New System.Windows.Forms.ComboBox
        Me.label7 = New System.Windows.Forms.Label
        Me.udNotifyTime = New System.Windows.Forms.NumericUpDown
        Me.label4 = New System.Windows.Forms.Label
        Me.udPersistTime = New System.Windows.Forms.NumericUpDown
        Me.Label2 = New System.Windows.Forms.Label
        Me.cboNotifyFormat = New System.Windows.Forms.ComboBox
        Me.label8 = New System.Windows.Forms.Label
        Me.btnClear = New System.Windows.Forms.Button
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.groupBox1.SuspendLayout()
        CType(Me.numericUpDown1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox9.SuspendLayout()
        Me.groupBox7.SuspendLayout()
        CType(Me.dgTags, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.groupBox2.SuspendLayout()
        CType(Me.udNotifyTime, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.udPersistTime, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'groupBox1
        '
        Me.groupBox1.Controls.Add(Me.numericUpDown1)
        Me.groupBox1.Controls.Add(Me.cboPorts)
        Me.groupBox1.Controls.Add(Me.label3)
        Me.groupBox1.Controls.Add(Me.label1)
        Me.groupBox1.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.groupBox1.Location = New System.Drawing.Point(16, 432)
        Me.groupBox1.Name = "groupBox1"
        Me.groupBox1.Size = New System.Drawing.Size(184, 104)
        Me.groupBox1.TabIndex = 16
        Me.groupBox1.TabStop = False
        Me.groupBox1.Text = "Com Port"
        '
        'numericUpDown1
        '
        Me.numericUpDown1.Increment = New Decimal(New Integer() {100, 0, 0, 0})
        Me.numericUpDown1.Location = New System.Drawing.Point(96, 64)
        Me.numericUpDown1.Maximum = New Decimal(New Integer() {2147483647, 0, 0, 0})
        Me.numericUpDown1.Minimum = New Decimal(New Integer() {60000, 0, 0, 0})
        Me.numericUpDown1.Name = "numericUpDown1"
        Me.numericUpDown1.Size = New System.Drawing.Size(64, 20)
        Me.numericUpDown1.TabIndex = 8
        Me.numericUpDown1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.numericUpDown1.ThousandsSeparator = True
        Me.numericUpDown1.Value = New Decimal(New Integer() {60000, 0, 0, 0})
        '
        'cboPorts
        '
        Me.cboPorts.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.cboPorts.Location = New System.Drawing.Point(96, 28)
        Me.cboPorts.Name = "cboPorts"
        Me.cboPorts.Size = New System.Drawing.Size(64, 21)
        Me.cboPorts.TabIndex = 13
        '
        'label3
        '
        Me.label3.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label3.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.label3.Location = New System.Drawing.Point(24, 36)
        Me.label3.Name = "label3"
        Me.label3.Size = New System.Drawing.Size(64, 20)
        Me.label3.TabIndex = 14
        Me.label3.Text = "Port Name:"
        '
        'label1
        '
        Me.label1.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label1.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.label1.Location = New System.Drawing.Point(16, 70)
        Me.label1.Name = "label1"
        Me.label1.Size = New System.Drawing.Size(80, 12)
        Me.label1.TabIndex = 6
        Me.label1.Text = "Timeout Interval:"
        '
        'txtResponse
        '
        Me.txtResponse.BackColor = System.Drawing.SystemColors.WindowFrame
        Me.txtResponse.CausesValidation = False
        Me.txtResponse.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.txtResponse.Location = New System.Drawing.Point(504, 440)
        Me.txtResponse.Multiline = True
        Me.txtResponse.Name = "txtResponse"
        Me.txtResponse.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.txtResponse.Size = New System.Drawing.Size(184, 96)
        Me.txtResponse.TabIndex = 18
        Me.ToolTip1.SetToolTip(Me.txtResponse, "Displays reader's responses")
        '
        'txtCommand
        '
        Me.txtCommand.BackColor = System.Drawing.SystemColors.WindowFrame
        Me.txtCommand.CausesValidation = False
        Me.txtCommand.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.txtCommand.Location = New System.Drawing.Point(504, 392)
        Me.txtCommand.Name = "txtCommand"
        Me.txtCommand.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.txtCommand.Size = New System.Drawing.Size(184, 24)
        Me.txtCommand.TabIndex = 20
        Me.ToolTip1.SetToolTip(Me.txtCommand, "Type in a command and hit <ENTER>")
        '
        'label6
        '
        Me.label6.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label6.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.label6.Location = New System.Drawing.Point(504, 424)
        Me.label6.Name = "label6"
        Me.label6.Size = New System.Drawing.Size(56, 16)
        Me.label6.TabIndex = 38
        Me.label6.Text = "Response: "
        '
        'label5
        '
        Me.label5.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label5.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.label5.Location = New System.Drawing.Point(504, 376)
        Me.label5.Name = "label5"
        Me.label5.Size = New System.Drawing.Size(56, 16)
        Me.label5.TabIndex = 37
        Me.label5.Text = "Command:"
        '
        'groupBox9
        '
        Me.groupBox9.Controls.Add(Me.lblNotifyTime)
        Me.groupBox9.Controls.Add(Me.txtNotifications)
        Me.groupBox9.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox9.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.groupBox9.Location = New System.Drawing.Point(16, 16)
        Me.groupBox9.Name = "groupBox9"
        Me.groupBox9.Size = New System.Drawing.Size(680, 232)
        Me.groupBox9.TabIndex = 59
        Me.groupBox9.TabStop = False
        Me.groupBox9.Text = "Last Notification at: "
        '
        'lblNotifyTime
        '
        Me.lblNotifyTime.Location = New System.Drawing.Point(144, 0)
        Me.lblNotifyTime.Name = "lblNotifyTime"
        Me.lblNotifyTime.Size = New System.Drawing.Size(200, 23)
        Me.lblNotifyTime.TabIndex = 37
        Me.lblNotifyTime.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'txtNotifications
        '
        Me.txtNotifications.BackColor = System.Drawing.SystemColors.WindowFrame
        Me.txtNotifications.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtNotifications.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.txtNotifications.Location = New System.Drawing.Point(8, 24)
        Me.txtNotifications.Multiline = True
        Me.txtNotifications.Name = "txtNotifications"
        Me.txtNotifications.ReadOnly = True
        Me.txtNotifications.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.txtNotifications.Size = New System.Drawing.Size(664, 200)
        Me.txtNotifications.TabIndex = 36
        '
        'groupBox7
        '
        Me.groupBox7.Controls.Add(Me.dgTags)
        Me.groupBox7.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox7.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.groupBox7.Location = New System.Drawing.Point(16, 248)
        Me.groupBox7.Name = "groupBox7"
        Me.groupBox7.Size = New System.Drawing.Size(680, 120)
        Me.groupBox7.TabIndex = 60
        Me.groupBox7.TabStop = False
        Me.groupBox7.Text = "Tag List"
        '
        'dgTags
        '
        Me.dgTags.BackgroundColor = System.Drawing.SystemColors.WindowFrame
        Me.dgTags.CaptionBackColor = System.Drawing.SystemColors.Info
        Me.dgTags.CaptionVisible = False
        Me.dgTags.DataMember = ""
        Me.dgTags.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.dgTags.ForeColor = System.Drawing.SystemColors.MenuText
        Me.dgTags.HeaderBackColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.dgTags.HeaderForeColor = System.Drawing.SystemColors.ControlText
        Me.dgTags.Location = New System.Drawing.Point(8, 16)
        Me.dgTags.Name = "dgTags"
        Me.dgTags.PreferredColumnWidth = 140
        Me.dgTags.RowHeadersVisible = False
        Me.dgTags.Size = New System.Drawing.Size(664, 96)
        Me.dgTags.TabIndex = 28
        '
        'groupBox2
        '
        Me.groupBox2.Controls.Add(Me.lblStatus)
        Me.groupBox2.Font = New System.Drawing.Font("Microsoft Sans Serif", 10.2!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.groupBox2.Location = New System.Drawing.Point(16, 376)
        Me.groupBox2.Name = "groupBox2"
        Me.groupBox2.Size = New System.Drawing.Size(456, 56)
        Me.groupBox2.TabIndex = 61
        Me.groupBox2.TabStop = False
        Me.groupBox2.Text = "Status"
        '
        'lblStatus
        '
        Me.lblStatus.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblStatus.Location = New System.Drawing.Point(16, 19)
        Me.lblStatus.Name = "lblStatus"
        Me.lblStatus.Size = New System.Drawing.Size(416, 29)
        Me.lblStatus.TabIndex = 0
        Me.lblStatus.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'chkNotifyMode
        '
        Me.chkNotifyMode.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.chkNotifyMode.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.chkNotifyMode.Location = New System.Drawing.Point(416, 448)
        Me.chkNotifyMode.Name = "chkNotifyMode"
        Me.chkNotifyMode.Size = New System.Drawing.Size(72, 19)
        Me.chkNotifyMode.TabIndex = 63
        Me.chkNotifyMode.Text = "Notify Mode"
        '
        'chkAutoMode
        '
        Me.chkAutoMode.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.chkAutoMode.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.chkAutoMode.Location = New System.Drawing.Point(416, 472)
        Me.chkAutoMode.Name = "chkAutoMode"
        Me.chkAutoMode.Size = New System.Drawing.Size(72, 19)
        Me.chkAutoMode.TabIndex = 64
        Me.chkAutoMode.Text = "  Auto Mode"
        '
        'cboNotifyTrigger
        '
        Me.cboNotifyTrigger.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cboNotifyTrigger.Items.AddRange(New Object() {"OFF", "ADD", "REMOVE", "CHANGE", "TRUE", "FALSE", "TRUEFALSE"})
        Me.cboNotifyTrigger.Location = New System.Drawing.Point(320, 440)
        Me.cboNotifyTrigger.Name = "cboNotifyTrigger"
        Me.cboNotifyTrigger.Size = New System.Drawing.Size(64, 20)
        Me.cboNotifyTrigger.TabIndex = 68
        '
        'label7
        '
        Me.label7.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label7.Location = New System.Drawing.Point(248, 440)
        Me.label7.Name = "label7"
        Me.label7.Size = New System.Drawing.Size(80, 16)
        Me.label7.TabIndex = 67
        Me.label7.Text = "Notify Trigger: "
        Me.label7.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'udNotifyTime
        '
        Me.udNotifyTime.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.udNotifyTime.Location = New System.Drawing.Point(336, 488)
        Me.udNotifyTime.Maximum = New Decimal(New Integer() {86400, 0, 0, 0})
        Me.udNotifyTime.Name = "udNotifyTime"
        Me.udNotifyTime.Size = New System.Drawing.Size(48, 19)
        Me.udNotifyTime.TabIndex = 65
        Me.udNotifyTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'label4
        '
        Me.label4.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label4.Location = New System.Drawing.Point(248, 488)
        Me.label4.Name = "label4"
        Me.label4.Size = New System.Drawing.Size(80, 16)
        Me.label4.TabIndex = 66
        Me.label4.Text = "Notify Time (sec): "
        Me.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'udPersistTime
        '
        Me.udPersistTime.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.udPersistTime.Location = New System.Drawing.Point(336, 464)
        Me.udPersistTime.Maximum = New Decimal(New Integer() {86400, 0, 0, 0})
        Me.udPersistTime.Name = "udPersistTime"
        Me.udPersistTime.Size = New System.Drawing.Size(48, 19)
        Me.udPersistTime.TabIndex = 69
        Me.udPersistTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        '
        'Label2
        '
        Me.Label2.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label2.Location = New System.Drawing.Point(248, 464)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(88, 16)
        Me.Label2.TabIndex = 70
        Me.Label2.Text = "Persist Time (sec): "
        Me.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft
        '
        'cboNotifyFormat
        '
        Me.cboNotifyFormat.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cboNotifyFormat.Items.AddRange(New Object() {"Text", "XML"})
        Me.cboNotifyFormat.Location = New System.Drawing.Point(320, 512)
        Me.cboNotifyFormat.Name = "cboNotifyFormat"
        Me.cboNotifyFormat.Size = New System.Drawing.Size(64, 20)
        Me.cboNotifyFormat.TabIndex = 72
        '
        'label8
        '
        Me.label8.Font = New System.Drawing.Font("Microsoft Sans Serif", 6.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.label8.Location = New System.Drawing.Point(248, 512)
        Me.label8.Name = "label8"
        Me.label8.Size = New System.Drawing.Size(80, 16)
        Me.label8.TabIndex = 71
        Me.label8.Text = "Notify Format: "
        '
        'btnClear
        '
        Me.btnClear.BackColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.btnClear.Font = New System.Drawing.Font("Microsoft Sans Serif", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnClear.ForeColor = System.Drawing.SystemColors.WindowText
        Me.btnClear.Location = New System.Drawing.Point(416, 504)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.Size = New System.Drawing.Size(72, 26)
        Me.btnClear.TabIndex = 73
        Me.btnClear.Text = "C&lear All"
        Me.ToolTip1.SetToolTip(Me.btnClear, "Clears Notifications Queue, TagList, and Response text")
        Me.btnClear.UseVisualStyleBackColor = False
        '
        'VBNotifications
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.BackColor = System.Drawing.SystemColors.ControlText
        Me.ClientSize = New System.Drawing.Size(712, 558)
        Me.Controls.Add(Me.btnClear)
        Me.Controls.Add(Me.cboNotifyFormat)
        Me.Controls.Add(Me.label8)
        Me.Controls.Add(Me.udPersistTime)
        Me.Controls.Add(Me.cboNotifyTrigger)
        Me.Controls.Add(Me.udNotifyTime)
        Me.Controls.Add(Me.chkAutoMode)
        Me.Controls.Add(Me.chkNotifyMode)
        Me.Controls.Add(Me.groupBox2)
        Me.Controls.Add(Me.groupBox7)
        Me.Controls.Add(Me.groupBox9)
        Me.Controls.Add(Me.label6)
        Me.Controls.Add(Me.label5)
        Me.Controls.Add(Me.txtCommand)
        Me.Controls.Add(Me.groupBox1)
        Me.Controls.Add(Me.txtResponse)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.label7)
        Me.Controls.Add(Me.label4)
        Me.ForeColor = System.Drawing.Color.FromArgb(CType(CType(255, Byte), Integer), CType(CType(255, Byte), Integer), CType(CType(192, Byte), Integer))
        Me.Name = "VBNotifications"
        Me.Text = "AlienRFID1.NET - Testing Serial Notifications  in VB.Net"
        Me.groupBox1.ResumeLayout(False)
        CType(Me.numericUpDown1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox9.ResumeLayout(False)
        Me.groupBox9.PerformLayout()
        Me.groupBox7.ResumeLayout(False)
        CType(Me.dgTags, System.ComponentModel.ISupportInitialize).EndInit()
        Me.groupBox2.ResumeLayout(False)
        CType(Me.udNotifyTime, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.udPersistTime, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Dim WithEvents mReader As clsReader
    Dim WithEvents mTimer As System.Timers.Timer    ' check the queue and display info
    Dim mdUpdateInterval As Double = 1000           ' for setting the mTimer.Interval
    Dim mNotificationsQ As Queue = New Queue        ' collect all notifications sent from another thread
    Dim mbInsideElapsed As Boolean = False
    ReadOnly moTimerLock As Object = New Object

    ' Perform Serial discovery and select COM port where the reader found
    Sub checkPorts()
        Dim ri() As ReaderInfo
        Dim monitor As clsReaderMonitor = New clsReaderMonitor

        monitor.ComPortsMonitoring = False
        Dim stat As String = monitor.CheckComPorts()

        Thread.Sleep(1000)   ' to give some time for closing "unmanaged" com port(s)

        If (stat.IndexOf("No reader found") >= 0) Then
            lblStatus.Text = "The 'monitor.CheckComPorts()' returned: " + stat
        Else
            '#region "Fill combo box with COMs found"...
            Dim cnt As Integer = monitor.GetReaderListOnSerial(ri)
            If (cnt = 0) Then
                lblStatus.Text = "No Alien readers found on Com ports"
            Else
                cboPorts.Items.Clear()
                Dim i As Integer
                For i = 0 To i
                    cboPorts.Items.Add(("COM" + ri(i).ComPort.ToString()))
                Next
                cboPorts.Text = cboPorts.Items(0).ToString
            End If
            '#endregion
        End If
    End Sub

    ' Connect to the reader
    Sub connectCom()
        If (mReader.IsConnected) Then
            mReader.Disconnect()
        End If

        If (cboPorts.Text.Length > 0) Then
            mReader.InitOnCom(Integer.Parse(cboPorts.Text.Substring(3, 1)))
            Dim response As String = mReader.Connect()
            lblStatus.Text = response
        End If

    End Sub


    Private Sub Ex9vb_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim exePath As String
        Dim idx As Integer

        exePath = Application.ExecutablePath
        idx = exePath.LastIndexOf("\\")
        If Not idx = -1 Then
            AlienLog.Path = exePath.Substring(0, idx + 1)
        End If
        AlienLog.WriteLine(True, "Starting the 'Ex9-Serial Notifications' application.")

        mReader = New clsReader(True)

        checkPorts()
        AddHandler mReader.MessageReceived, AddressOf mReader_MessageReceived

        mTimer = New System.Timers.Timer(mdUpdateInterval)
        mTimer.SynchronizingObject = Me
        AddHandler mTimer.Elapsed, AddressOf mTimer_Elapsed
        mTimer.AutoReset = True

        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                mReader.NotifyAddress = "Serial"
            End If
        End If
        udPersistTime.Text = "5"
        udNotifyTime.Text = "5"
        cboNotifyTrigger.SelectedIndex = 0
        cboNotifyFormat.SelectedIndex = 0
        chkNotifyMode.Checked = True
        chkAutoMode.Checked = True

        mTimer.Start()

    End Sub


    Private Sub txtCommand_KeyUp(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles txtCommand.KeyUp
        Dim command As String = ""
        Dim response As String = ""

        If (e.KeyCode = Keys.Enter) Then
            command = txtCommand.Text
            If (command.Length > 0) Then
                Me.Cursor = Cursors.WaitCursor
                Try
                    response = mReader.SendReceive(command, False)
                Catch ex As Exception
                    response = ex.Message
                End Try
                txtResponse.Text += (vbCr + vbLf + response)
                Me.Cursor = Cursors.Default
                txtCommand.SelectAll()
            End If
        End If

    End Sub

    Private Sub numericUpDown1_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles numericUpDown1.ValueChanged
        If (Not mReader Is Nothing) Then
            mReader.ComTimeOutInterval = numericUpDown1.Value
        End If
    End Sub

    Private Sub cboPorts_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboPorts.SelectedIndexChanged
        Me.Cursor = Cursors.WaitCursor
        connectCom()
        Me.Cursor = Cursors.Default
    End Sub

    Public Sub mTimer_Elapsed(ByVal source As Object, ByVal e As ElapsedEventArgs)
        SyncLock (moTimerLock)
            'If mbInsideElapsed Then Return
            'mbInsideElapsed = True

            Dim alTags As ArrayList = New ArrayList
            Dim cnt As Integer = 0

            mTimer.Stop()
            SyncLock (mNotificationsQ.SyncRoot)
                Try
                    While (mNotificationsQ.Count > 0)
                        Dim ni As NotifyInfo
                        Dim aTags() As TagInfo ' if no header we'll get tag list only
                        Dim data As String = CType(mNotificationsQ.Dequeue(), String)

                        If ((data.IndexOf("#Alien RFID Reader Auto Notification Message") >= 0) Or _
                               (data.IndexOf("<Alien-RFID-Reader-Auto-Notification>") >= 0)) Then

                            '#region "Parse full notification"...
                            Dim idx As Integer = data.IndexOf("Alien")
                            If (idx > 0) Then
                                Dim notification As String = data.Substring(idx - 1)
                                txtNotifications.Text = data
                                cnt = AlienUtils.ParseNotification(notification, ni)

                                If (Not ni Is Nothing) Then

                                    lblNotifyTime.Text = ni.Time
                                    Dim name As String = ni.ReaderName
                                    Dim record As String = ""
                                    If (idx = 1) Then 'received on serial
                                        record = name + " on COM" + cboPorts.Text.Substring(3, 1)
                                    Else   'received on TCP
                                        record = name + " on " + ni.IPAddress
                                    End If
                                End If
                            End If
                            '#endregion
                        Else ' no reader info in the notification only tag list

                            '#region "Parse tag list only"...
                            Dim idx As Integer = data.IndexOf("<")
                            If (idx >= 0) Then ' XML data
                                AlienUtils.ParseXMLTagList(data.Substring(idx), aTags)
                                If (Not aTags Is Nothing) Then
                                    cnt = aTags.Length
                                End If
                                txtNotifications.Text = data.Substring(idx)
                            Else      ' text data
                                idx = data.IndexOf("Tag:")
                                If (idx >= 0) Then
                                    AlienUtils.ParseTextTagList(data.Substring(idx), aTags)
                                    If (Not aTags Is Nothing) Then
                                        cnt = aTags.Length
                                        txtNotifications.Text = data.Substring(idx)
                                    End If
                                End If
                            End If
                            '#endregion
                            lblNotifyTime.Text = DateTime.Now.ToString()
                        End If
                        ' update DataGrid
                        If (cnt > 0) Then
                            If (Not aTags Is Nothing) Then
                                alTags = New ArrayList(aTags)
                            Else
                                alTags = New ArrayList(ni.TagList)
                            End If

                            dgTags.DataSource = alTags

                        Else
                            dgTags.DataSource = Nothing
                        End If

                        lblStatus.Text = cnt.ToString() + " tags found."
                    End While

                Catch ex As Exception
                    lblStatus.Text = ex.Message
                End Try

                mTimer.Start()
                'mbInsideElapsed = False

            End SyncLock
        End SyncLock
    End Sub

    Private Sub VBNotifications_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        If (Not mReader Is Nothing) Then
            mReader.Dispose()
            SyncLock (moTimerLock)
                mTimer.Enabled = False
                mTimer.Dispose()
            End SyncLock
        End If
    End Sub

    Private Sub chkAutoMode_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkAutoMode.CheckedChanged
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                Dim state As Boolean = chkAutoMode.Checked
                Dim scommand As String = "Set AutoMode = " + IIf(state, "On", "OFF")
                Dim response As String = mReader.SendReceive(scommand, False)
                txtResponse.Text = response
            End If
        End If
    End Sub

    Private Sub chkNotifyMode_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkNotifyMode.CheckedChanged
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                Dim state As Boolean = chkNotifyMode.Checked
                Dim scommand As String = "Set NotifyMode = " + IIf(state, "On", "OFF")
                Dim response As String = mReader.SendReceive(scommand, False)
                txtResponse.Text = response
            End If
        End If
    End Sub

    Private Sub cboNotifyTrigger_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboNotifyTrigger.SelectedIndexChanged
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                Dim str As String = cboNotifyTrigger.Text
                Dim scommand As String = "Set NotifyTrigger = " + str
                Dim response As String = mReader.SendReceive(scommand, False)
                txtResponse.Text = response
            End If
        End If
    End Sub

    Private Sub udNotifyTime_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles udNotifyTime.ValueChanged
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                Dim scommand As String = "Set NotifyTime = " + udNotifyTime.Value.ToString()
                Dim response As String = mReader.SendReceive(scommand, False)
                txtResponse.Text = response
                If (response = udNotifyTime.Value.ToString()) Then
                    mTimer.Stop()
                    If (udNotifyTime.Value = 0) Then
                        mTimer.Interval = 1000
                    Else
                        mTimer.Interval = Double.Parse(response) * 1000 / 2
                    End If
                    mTimer.Start()
                End If
            End If
        End If
    End Sub

    Private Sub udPersistTime_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles udPersistTime.ValueChanged
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                Dim scommand As String = "Set PersistTime = " + udPersistTime.Value.ToString()
                Dim response As String = mReader.SendReceive(scommand, False)
                txtResponse.Text = response
            End If
        End If
    End Sub

    Private Sub cboNotifyFormat_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboNotifyFormat.SelectedIndexChanged
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                Dim str As String = cboNotifyFormat.Text
                Dim scommand As String = "Set NotifyFormat = " + str
                Dim response As String = mReader.SendReceive(scommand, False)
                txtResponse.Text = response
            End If
        End If
    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        If Not mReader Is Nothing Then
            If mReader.IsConnected = True Then
                mReader.ClearTagList()
                txtNotifications.Clear()
                mNotificationsQ.Clear()
                txtResponse.Clear()
                dgTags.DataSource = Nothing
            End If
        End If
    End Sub

    Private Sub mReader_MessageReceived(ByVal data As String) Handles mReader.MessageReceived

        If (txtResponse.InvokeRequired()) Then

            SyncLock (mNotificationsQ.SyncRoot)
                mNotificationsQ.Enqueue(data)
            End SyncLock

        Else    ' show as a response
            txtResponse.Text = data + vbCr
        End If

    End Sub
End Class
